/** @file   HotSpot.cpp
 * @brief   Declaration of HotSpot class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/05/15 19:23:34 $
 * @author  Tomi Lamminsaari
 */
 
#include "HotSpot.h"

namespace WeWantWar {

HotSpot::HotSpot() :
  GameObject(),
  iCurrentState( MUsableObject::EReady )
{
}

HotSpot::~HotSpot()
{
}

void HotSpot::update()
{
  switch ( iCurrentState ) {
    case ( MUsableObject::EStarting ): {
      iCurrentState = this->updateStarting();
      break;
    }
    case ( MUsableObject::EActive ): {
      iCurrentState = this->updateActive();
      break;
    }
    case ( MUsableObject::EStopping ): {
      iCurrentState = this->updateStopping();
      break;
    }
    default: {
      break;
    }
  }
}

void HotSpot::redraw( RedrawQueue* aQueue )
{
}

bool HotSpot::hitByBullet( Bullet* aBullet )
{
  return false;
}

void HotSpot::kill()
{
}

void HotSpot::makeSound( GameObject::SoundID aSoundId ) const
{
}

ObjectID::Type HotSpot::objectType() const
{
  return ObjectID::TYPE_HOTSPOT;
}

bool HotSpot::reloading() const
{
  return false;
}

int HotSpot::doActivate()
{
  if ( iCurrentState == MUsableObject::EReady ) {
    iCurrentState = MUsableObject::EStarting;
    this->hotSpotActivated();
    
  }
  return 0;
}

MUsableObject::State HotSpot::currentState() const
{
  return iCurrentState;
}
  
}
